/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.report.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.report.dto.AttendanceTableDto;

public class AttendanceTableDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE		= "M_KIHON"		;
	public static final String TABLE2		= "M_SYOZOKU"	;
	public static final String KEY1		= "SCODE"		;

	// 
	public static final String COL_KCODE	= "KCODE";
	public static final String COL_SIMEI	= "SIMEI";
	public static final String COL_SNAME	= "SNAME";

	/**
	 * RXgN^
	 */
	public AttendanceTableDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<AttendanceTableDto> mappingAll() throws SQLException {
		List<AttendanceTableDto> all = new ArrayList<AttendanceTableDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return m_kintaiDto m_kintaiR[h
	 * @throws SQLException
	 */
	private AttendanceTableDto mapping() throws SQLException {
		AttendanceTableDto dto = new AttendanceTableDto();
		dto.setSimei(rs.getString (COL_SIMEI));
		dto.setSName(rs.getString (COL_SNAME));
		return dto;
	}

	/**
	 * ɂf[^擾	  
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<AttendanceTableDto> findForCondition(
			String kcode			
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_SIMEI    + MospConst.DATA_SEPARATOR );
		sb.append(COL_SNAME   );		
		sb.append(" FROM ");
		sb.append( TABLE );
		sb.append(" INNER JOIN ");
		sb.append( TABLE2 );
		sb.append(" ON ");
		sb.append( TABLE + "."+ KEY1 );
		sb.append(" = ");
		sb.append( TABLE2 +"."+ KEY1 );
		sb.append(" WHERE ");
		sb.append(TABLE + "." + COL_KCODE);
		sb.append(" = ? ");
		try {
			prepareStatement(sb.toString());
			setParam(index++,   kcode);
			executeQuery();
			List<AttendanceTableDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

}
